USE master
GO
DECLARE @isicore_backup_dir nvarchar(150) = 'E:\SQLBackup\';
DECLARE isicore_cur
CURSOR FOR SELECT name FROM sys.databases WHERE name NOT IN ('tempdb')
DECLARE @isicore_db_name nvarchar(100);
DECLARE @isicore_backup_name nvarchar(250);
OPEN isicore_cur;
FETCH FROM isicore_cur INTO @isicore_db_name;
WHILE @@FETCH_STATUS = 0
BEGIN
SELECT @isicore_backup_name = @isicore_backup_dir + @isicore_db_name + '.trn';
BACKUP LOG @isicore_db_name
TO DISK = @isicore_backup_name
WITH FORMAT, MEDIANAME = @isicore_db_name, NAME = @isicore_db_name;
FETCH NEXT FROM isicore_cur into @isicore_db_name;
END CLOSE isicore_cur
DEALLOCATE isicore_cur
GO